  
  OPTION BASE 1
  OPTION EXPLICIT
  
  CONST White = RGB(WHITE)
  
  DIM FLOAT AMPNOISE = 0
  DIM INTEGER AMPOFFSET = 0
  DIM INTEGER AVGDCLEVEL = 0
  DIM INTEGER Vscale = 1000
  DIM INTEGER Ascale = 1600
  DIM INTEGER Orig_scales
  
  DIM float volts = 0, amps = 0, va = 0, pf = 0, frequency = 0, sampling_rate = 0, avg_v, avg_a, avg_w
  DIM INTEGER num_avgs = 0
  
  DIM INTEGER data_store(5040)'(max_datum \ 2)
  DIM INTEGER num_datum = 0
  DIM INTEGER log_duration = 0
  DIM INTEGER eeprom_address = 0
  DIM INTEGER accum_mWs = 0, wait_mWs = 0
  DIM INTEGER accum_cost_mc = 0
  DIM INTEGER zero_crossings = 0
  DIM INTEGER tariffs(3) = (0,0,0) 'off-peak, shoulder, peak
  DIM STRING tariff_times$ LENGTH 64 = SPACE$(64)
  DIM STRING tariff_holidays$ LENGTH 132 = SPACE$(132)
  
  DIM INTEGER touchpos(2) = (-1,-1)
  DIM INTEGER log_interval = 1
  DIM INTEGER log_wait = 0
  DIM INTEGER logging_status = 1   ' 0 = stopped, 1 = running, 2 = paused
  DIM STRING last_graph$ LENGTH 20 = ""
  DIM INTEGER graph_duration = 3600
  DIM STRING cur_screen$ LENGTH 6 = "main"
  DIM STRING LASTTIME$ LENGTH 8, CHECKTIME$ LENGTH 8
  
  DIM STRING KPad$ LENGTH 16 = "789456123x0."
  
SUB TouchInt
  touchpos(1) = TOUCH(X)
  touchpos(2) = TOUCH(Y)
END SUB
  
Sub eeWriteInt (address, val%)
  Local msb, lsb, count
  
  I2C open 100,100
  msb=address\256
  lsb=address Mod 256
  
  FOR count = 0 TO 7
    '    PRINT "w" + STR$(lsb+count) + " " + STR$(val% and 255)
    I2C write &H57, 0, 3, msb, lsb+count, val% AND 255
    PAUSE 1
    val% = val% >> 8
  NEXT count
  I2C close
End Sub
  
Function eeReadInt(address) AS INTEGER
  Local msb, lsb, count
  LOCAL INTEGER eeReadB
  
  I2C open 100,100
  msb=address\256
  lsb=address Mod 256
  
  eeReadInt = 0
  FOR count = 0 TO 7
    I2C write &H57, 0,2,msb,lsb+count
    I2C read &H57, 0,1,eeReadB
    '    PRINT "r" + STR$(lsb+count) + " " + STR$(eeReadB)
    eeReadInt = eeReadInt + (eeReadB << (count*8))
  NEXT count
  I2C close
End Function
  
SUB store_readings
  LOCAL INTEGER value = (((log_duration * log_interval) \ 60) AND &HFFFFF) + (((accum_mWs \ 3600000) AND &HFFFFFF) << 20) + ((accum_cost_mc \ 1000) << 44)
  LOCAL new_addr = (eeprom_address + 8) MOD 4096
  eeWriteInt new_addr, -1
  eeWriteInt eeprom_address, value
  eeprom_address = new_addr
END SUB
  
SUB restore_readings
  accum_mWs = eeReadInt(0)
  WHILE eeprom_address < 4096 AND eeReadInt(eeprom_address) <> -1
    eeprom_address = eeprom_address+8
  WEND
  IF eeprom_address = 4096 THEN
    eeprom_address = 0
  ELSE
    eeprom_address = (eeprom_address + 4088) MOD 4096
    LOCAL INTEGER value = eeReadInt(eeprom_address)
    log_duration = (value AND &HFFFFF) * 60 \ log_interval
    accum_mWs = ((value >> 20) AND &HFFFFFF) * 3600000
    accum_cost_mc = (value >> 44) * 1000
'    PRINT "r " + STR$(accum_cost_mc) + "@" + STR$(eeprom_address)
  ENDIF
END SUB
  
FUNCTION MYTIME$()
  LOCAL temp$ length 10 = TIME$
  LOCAL hour = VAL(LEFT$(temp$, 2))
  LOCAL am_pm$ LENGTH 4 = "am"
  IF hour = 0 THEN
    hour = 12
  ELSEIF hour > 12 THEN
    hour = hour - 12
    am_pm$ = "pm"
  ENDIF
  MYTIME$ = STR$(hour) + RIGHT$(temp$, 6) + am_pm$
END FUNCTION
  
FUNCTION duration_str$(seconds_, opts$)
  LOCAL INTEGER seconds = seconds_
  LOCAL days = seconds \ 86400
  seconds = seconds - days * 86400
  LOCAL hours = seconds \ 3600
  seconds = seconds - hours * 3600
  LOCAL minutes = seconds \ 60
  seconds = seconds - minutes * 60
  LOCAL secs$ LENGTH 2 = LPAD0$(STR$(seconds), 2)
  LOCAL mins$ LENGTH 5 = LPAD0$(STR$(minutes), 2) + ":" + secs$
  IF days = 0 THEN
    IF opts$ = "daysonly" THEN
      duration_str$ = "0 days"
    ELSEIF hours = 0 THEN
      duration_str$ = STR$(minutes) + ":" + secs$
    ELSE
      duration_str$ = STR$(hours) + ":" + mins$
    ENDIF
  ELSEIF days = 1 THEN
    IF opts$ = "nodays" THEN
      duration_str$ = STR$(hours) + ":" + mins$
    ELSEIF opts$ = "daysonly" THEN
      duration_str$ = "1 day"
    ELSE
      duration_str$ = "1 day, " + STR$(hours) + ":" + mins$
    ENDIF
  ELSE
    IF opts$ = "nodays" THEN
      duration_str$ = STR$(hours) + ":" + mins$
    ELSEIF opts$ = "daysonly" THEN
      duration_str$ = STR$(days) + " days"
    ELSE
      duration_str$ = STR$(days) + " days, " + STR$(hours) + ":" + mins$
    ENDIF
  ENDIF
END FUNCTION
  
FUNCTION LIMSTR$(value)
  IF value >= 1000 THEN
    LIMSTR$ = STR$(value \ 1000) + "K" + STR$(CINT((value MOD 1000) / 10))
  ELSEIF value <> CINT(value) THEN
    IF value > 100 THEN
      LIMSTR$ = STR$(CINT(value))
    ELSEIF value > 10 THEN
      LIMSTR$ = STR$(value, 2, 1)
    ELSE
      LIMSTR$ = STR$(value, 1, 2)
    ENDIF
  ELSE
    LIMSTR$ = STR$(value)
  ENDIF
END FUNCTION
  
SUB draw_graph values(), round, num, LEFT, RIGHT, TOP, BOTTOM, duration
  LOCAL min = 99999999, max = -99999999', avg = 0
  LOCAL count
  for count = 1 to num
    if values(count) < min THEN min = values(count)
    if values(count) > max THEN max = values(count)
  NEXT count
  
  LOCAL imin = CINT(min / round - 0.5) * round, imax = CINT(max / round + 0.499999) * round
  if imin < 0 THEN imin = 0
  LOCAL vrange = imax - imin
  IF vrange = 0 THEN vrange = 1
  
  COLOUR White
  TEXT LEFT-2, TOP, LIMSTR$(imax), rm, 1
  TEXT LEFT-2, BOTTOM, LIMSTR$(imin), rm, 1
  TEXT LEFT+10, BOTTOM+1, duration_str$(duration) + " ago", lt, 1
  LINE LEFT, BOTTOM+2, LEFT, BOTTOM+8
  LINE LEFT, BOTTOM+8, LEFT+8, BOTTOM+8
  TEXT RIGHT-8, BOTTOM+1, "now", rt, 1
  LINE RIGHT, BOTTOM+2, RIGHT, BOTTOM+8
  LINE RIGHT, BOTTOM+8, RIGHT-6, BOTTOM+8
  LOCAL HEIGHT = BOTTOM - TOP
  BOX LEFT, TOP, RIGHT-LEFT, HEIGHT, 1, rgb(192,192,192)
  
  LOCAL vmod = 1, vstep = 0
  WHILE vrange > 8 * vmod * round
    if vstep = 0 THEN
      vmod = vmod * 2
    ELSEif vstep = 1 THEN
      vmod = vmod * 5 / 2
    ELSE
      vmod = vmod * 2
    ENDIF
    vstep = (vstep + 1) MOD 3
  WEND
  
  LOCAL val
  LOCAL INTEGER start = imin / round, finish = imax / round
  for val = start - start MOD vmod to finish - finish MOD vmod STEP vmod
    line left+1, TOP + (imax - VAL * round) * HEIGHT / vrange, RIGHT-1, TOP + (imax - VAL * round) * HEIGHT / vrange, , RGB(128,128,128)
  next VAL
  
  LOCAL tdiv = 1, tstep = 0
  WHILE duration > 10 * tdiv
    if tstep = 0 THEN
      tdiv = tdiv * 5
    ELSEif tstep = 2 THEN
      tdiv = tdiv * 3
    ELSE
      tdiv = tdiv * 2
    ENDIF
    tstep = (tstep + 1) MOD 4
  WEND
  
  LOCAL x, time_ago
  for time_ago = 0 to duration STEP tdiv
    x = RIGHT - (right-left) * time_ago / duration
    line x, bottom+1, x, top, , rgb(128,128,128)
  next time_ago
  
  for count = 1 to num-1
    LINE LEFT + (RIGHT - LEFT) * (count-1) / (num-1), TOP + (imax - values(count)) * HEIGHT / vrange, LEFT + (RIGHT - LEFT) * (count) / (num-1), TOP + (imax - values(count+1)) * HEIGHT / vrange
  NEXT count
END SUB
  
SUB HISTOGRAM ROUND, start, finish, what$, numbins, LEFT, RIGHT, TOP, BOTTOM, MINUTES, NO_CLEAR, min, max, avg
  LOCAL count, datum
  LOCAL bins(numbins)'max_bins)
  FOR count = 1 TO numbins
    bins(count) = 0
  NEXT count
  
  min = 99999999
  max = -99999999
  avg = 0
  for count = start to finish-1
    datum = get_datum(count, what$)
    IF datum < min THEN min = datum
    IF datum > max THEN max = datum
    avg = avg + datum
    IF touchpos(1) <> -1 THEN count = finish-1
    IF count MOD 120 = 0 THEN next_reading
  NEXT count
  IF touchpos(1) <> -1 THEN goto aborthist
  IF finish > start THEN avg = avg / (finish - start)
  
  IF last_graph$ <> (what$ + "hist") + STR$(finish - start) + "," + STR$(start) THEN
    LOCAL range = max - min, maxbin = 0, bin
    IF range = 0 THEN range = 1
    LOCAL invrange = (numbins - 0.00001)/range
    for count = start to finish-1
      datum = get_datum(count, what$)
      bin = 1 + FIX((datum - min) * invrange)
      if BIN > numbins THEN BIN = numbins
      bins(BIN) = bins(BIN) + 1
      if bins(BIN) > maxbin THEN maxbin = bins(BIN)
    NEXT count
    
    LOCAL L, R
    LOCAL newstr$ LENGTH 10, laststr$ LENGTH 10, endstr$ LENGTH 10
    if round < 1 THEN
      endstr$ = STR$(max, 0, 1)
    ELSE
      endstr$ = STR$(max, 0, 0)
    ENDIF
    IF maxbin = 0 THEN maxbin = 1
    
    '    IF NO_CLEAR > 0 THEN BOX LEFT, TOP, RIGHT-LEFT, BOTTOM+16-TOP, 0, , RGB(black)
    BOX LEFT, TOP, RIGHT-LEFT, BOTTOM+16-TOP, 0, , RGB(black)
    COLOUR White
    FOR count = 1 TO numbins
      L = LEFT + 2 + (RIGHT - LEFT) * (count - 1) / numbins
      R = LEFT - 2 + (RIGHT - LEFT) * (count) / numbins
      BOX L, TOP + (BOTTOM - TOP) * (maxbin - bins(count)) / maxbin, R - L, (BOTTOM - TOP) * bins(count) / maxbin
      if round < 1 THEN
        newstr$ = STR$(min + range * (count-1) / numbins, 0, 1)
      ELSE
        newstr$ = STR$(min + range * (count-1) / numbins, 0, 0)
      ENDIF
      if COUNT = 1 OR COUNT = numbins OR (newstr$ <> laststr$ and newstr$ <> endstr$) THEN
        TEXT L - 2, BOTTOM+2, newstr$, ct, 1
        laststr$ = newstr$
      ENDIF
    NEXT count
    TEXT R + 2, BOTTOM+2, endstr$, ct, 1
    
    last_graph$ = (what$ + "hist") + STR$(finish - start) + "," + STR$(start)
  ENDIF
aborthist:
END SUB
  
SUB Calibrate
  LOCAL INTEGER reading_count, volt_sum, amp_sum, va_sum, w_sum, zerocross_count, amp_avg, amp_count
  LOCAL amp_noise, count
  
  CLS
  RBOX 0,0, MM.HRes-2, MM.VRes-2, 4, RGB(Cyan), RGB(0, 0, 128)
  '  TEXT 20, MM.VRes/4, "0", LM, 9, 1, RGB(Red), RGB(0, 0, 128)   ' this is the SC logo char/font
  COLOUR White, RGB(0,0,128)
  TEXT MM.HRes/2, MM.VRes*3/16, "Silicon Chip", CM, 1, 2
  TEXT MM.HRes/2, MM.VRes*5/16, "Appliance Energy", CM, 1, 2
  TEXT MM.HRes/2, MM.VRes*7/16, "Meter v1.01", CM, 1, 2
  '  TEXT MM.HRes/2, MM.VRes*11/16, "Please wait,", CM, 1, 2
  TEXT MM.HRes/2, MM.VRes*13/16, "Calibrating...", CM, 1, 2
  COLOUR WHITE, RGB(0,0,0)
  
  amp_count = ReadVA(10, 0)
  amp_count = ReadVA(6, amp_avg)
  PAUSE 500
  amp_count = ReadVA(6, amp_avg)
  AMPOFFSET = -amp_avg / amp_count
  amp_count = ReadVA(10, AMPOFFSET)
  PAUSE 250
  zerocross_count = ReadVA(8, volt_sum, amp_sum, va_sum, w_sum, reading_count)
  AMPNOISE = 0
  FOR count = 1 to 16
    PAUSE 100
    zerocross_count = ReadVA(8, volt_sum, amp_sum, va_sum, w_sum, reading_count)
    amp_noise = SQR(amp_sum / reading_count) / Ascale
    IF amp_noise > AMPNOISE THEN AMPNOISE = amp_noise
    '    PRINT(STR$(amp_noise))
    '    AMPNOISE = AMPNOISE + amp_noise / 16
    '    amp_noise = va_sum / reading_count / (SQR(volt_sum / reading_count) * Ascale)
    '    IF amp_noise > AMPNOISE THEN AMPNOISE = amp_noise
  NEXT count
'  AMPNOISE = amp_noise / 16
  AVGDCLEVEL = ReadVA(9)
  VAR SAVE AMPNOISE, AMPOFFSET, AVGDCLEVEL
END SUB
  
SUB WAITFORPRESS sc$
  LOCAL INTEGER x, y
Top:
  DO WHILE touchpos(1) = -1
    IF sc$ <> "" THEN
      next_reading
      SHOW_SCREEN sc$, 1
    ENDIF
  LOOP
  x = touchpos(1)
  y = touchpos(2)
  touchpos(1) = -1
  if x <> -1 and y <> -1 THEN
    if sc$ = "main" THEN
      graph_duration = 3600
      IF y < 48 THEN
        if x < 160 THEN
          sc$ = "vplot"
        ELSE
          sc$ = "wplot"
        ENDIF
      ELSE IF y < 96 THEN
        if x < 160 THEN
          sc$ = "aplot"
        ELSE
          sc$ = "vaplot"
        ENDIF
      ELSE IF y < 144 THEN
        if x < 160 THEN
          sc$ = "pfplot"
        ELSE
          sc$ = "energy"
        ENDIF
      ELSE IF y < 192 THEN
        if x < 160 THEN
          sc$ = "tariff"
        ELSE
          sc$ = "cost"
        ENDIF
      ELSE
        if x < 160 THEN
          sc$ = "log"
        ELSE
          LOCAL t$ LENGTH 16, d$ LENGTH 16, nt$ LENGTH 16, nd$ LENGTH 16
          LOCAL changed = 0
          t$ = TIME$
          d$ = MYDATE$(2)
          nt$ = GetStr$("Current time (24hr):", "", "New time (24hr):", t$, ":", 8, 1)
          nd$ = GetStr$("Current date (d/m/y):", "", "New date (d/m/y):", d$, "/", 10, 1)
          IF nt$ <> "" AND nt$ <> t$ THEN
            TIME$ = nt$
            changed = 1
          ENDIF
          IF nd$ <> "" AND nd$ <> d$ THEN
            DATE$ = nd$
            changed = 1
          ENDIF
          LOCAL INTEGER yr, mo, da, h, mi
          t$ = RIGHT$(DATE$, 2)
          yr = VAL(t$)
          t$ = MID$(DATE$,4,2)
          mo = VAL(t$)
          t$ = LEFT$(DATE$,2)
          da = VAL(t$)
          t$ = LEFT$(TIME$,2)
          h = VAL(t$)
          t$ = MID$(TIME$,4,2)
          mi = VAL(t$)
          t$ = RIGHT$(TIME$,2)
          IF changed > 0 THEN RTC SETTIME yr, mo, da, h, mi, VAL(t$)
        ENDIF
      ENDIF
    ELSEIF RIGHT$(sc$, 4) = "plot" OR RIGHT$(sc$, 4) = "hist" THEN
      if y > 200 THEN
        if graph_duration = 3600 THEN
          graph_duration = 86400
        ELSEIF graph_duration = 86400 THEN
          graph_duration = 86400 * 7
        ELSE
          graph_duration = 3600
        ENDIF
      ELSEIF RIGHT$(sc$, 4) = "plot" THEN
        sc$ = left$(sc$, LEN(sc$)-4) + "hist"
      ELSE
        sc$ = "main"
      ENDIF
    ELSEIF sc$ = "tariff" THEN
      IF y < 30 THEN
        IF x < 100 THEN
          sc$ = "main"
        ELSE
          LOCAL cur_str$ LENGTH 6 = STR$(tariffs(3)/1000, 0, 2)
          cur_str$ = GetStr$("Peak cost:", "c/kWh", "New cost:", cur_str$, ".", 6, 0)
          IF cur_str$ <> "" THEN
            tariffs(3) = val(cur_str$) * 1000
            VAR SAVE tariffs()
          ENDIF
        ENDIF
      ELSEIF y < 90 OR (y >= 120 and y < 180) THEN
        LOCAL st1$ LENGTH 5, fi1$ LENGTH 5, st2$ LENGTH 5, fi2$ LENGTH 5, ms$ LENGTH 32, ms2$ LENGTH 20, colon$ LENGTH 1 = ":"
        LOCAL INTEGER which = (y - 30) \ 30
        IF which > 1 THEN which = which - 1
        
        LOCAL day$ LENGTH 4, what$ LENGTH 8
        IF which < 2 THEN what$ = "Peak" ELSE what$ = "Shoulder"
        IF (which MOD 2) = 0 THEN day$ = "wday" ELSE day$ = "wend"
        
        get_tariffs(which, st1$, fi1$, st2$, fi2$)
        IF st1$ = st2$ THEN st2$ = "     "
        IF fi1$ = fi2$ THEN fi2$ = "     "
        ms$ = what$ + " " + day$ + " st #1:"
        ms2$ = "New st (hh:mm):"
        ms$ = GetStr$(ms$, , ms2$, st1$, colon$, 5, 2)
        IF ms$ <> "" THEN st1$ = ms$
        ms$ = what$ + " " + day$ + " fi #1:"
        ms2$ = "New fi (hh:mm):"
        ms$ = GetStr$(ms$, , ms2$, fi1$, colon$, 5, 2)
        IF ms$ <> "" THEN fi1$ = ms$
        IF st2$ = "     " THEN st2$ = st1$
        IF fi2$ = "     " THEN fi2$ = fi1$
        ms$ = what$ + " " + day$ + " st #2:"
        ms2$ = "New st (hh:mm):"
        ms$ = GetStr$(ms$, , ms2$, st2$, colon$, 5, 1)
        IF ms$ <> "" THEN st2$ = ms$
        ms$ = what$ + " " + day$ + " fi #2:"
        ms2$ = "New fi (hh:mm):"
        ms$ = GetStr$(ms$, , ms2$, fi2$, colon$, 5, 1)
        IF ms$ <> "" THEN fi2$ = ms$
        IF st2$ = "" THEN st2$ = st1$
        IF fi2$ = "" THEN fi2$ = fi1$
        save_tariffs(which, st1$, fi1$, st2$, fi2$)
      ELSEIF y < 120 THEN
        LOCAL cur_str$ LENGTH 6 = STR$(tariffs(2)/1000, 0, 2)
        cur_str$ = GetStr$("Shoulder cost:", "c/kWh", "New cost:", cur_str$, ".", 6, 0)
        IF cur_str$ <> "" THEN
          tariffs(2) = val(cur_str$) * 1000
          VAR SAVE tariffs()
        ENDIF
      ELSEIF y < 210 THEN
        LOCAL cur_str$ LENGTH 6 = STR$(tariffs(1)/1000, 0, 2)
        cur_str$ = GetStr$("Off-peak cost:", "c/kWh", "New cost:", cur_str$, ".", 6, 0)
        IF cur_str$ <> "" THEN
          tariffs(1) = val(cur_str$) * 1000
          VAR SAVE tariffs()
        ENDIF
      ELSE
        sc$ = "hols"
      ENDIF
    ELSEIF sc$ = "log" THEN
      IF x >= 15 and y >= 150 and x <= 15+90 and y <= 150+40 THEN
        IF logging_status > 0 THEN logging_status = 3-logging_status
      ELSEIF x >= 115 and y >= 150 and x <= 115+90 and y <= 150+40 THEN
        IF logging_status > 0 THEN logging_status = 0 ELSE logging_status = 1
        IF logging_status > 0 THEN
          num_datum = 0
          log_duration = 0
          accum_mWs = 0
          accum_cost_mc = 0
          log_wait = 0
          store_readings
        ENDIF
      ELSEIF x >= 215 and y >= 150 and x <= 215+90 and y <= 150+40 THEN
        IF num_datum > 0 and logging_status <> 1 THEN
          LOCAL INTEGER count, t
          LOCAL v, a, pf
          LOCAL temp$(8) LENGTH 18
          PRINT "SILICON CHIP Appliance Energy Meter log at "+TIME$+" "+MYDATE$(4)
          PRINT "num,seconds,time,v,a,va,power,pf"
          FOR count = 1 TO num_datum-1
            t = (count-1)*log_interval
            v = get_datum(count, "v")
            a = get_datum(count, "a")
            pf = get_datum(count, "pf")
            temp$(1) = STR$(count)
            temp$(2) = STR$(t)
            temp$(3) = duration_str$(t)
            temp$(4) = STR$(v,0,1)
            temp$(5) = STR$(a,0,3)
            temp$(6) = STR$(v*a,0,1)
            temp$(7) = STR$(v*a*pf,0,1)
            temp$(8) = STR$(pf,1,2)
            print temp$(1)+","+temp$(2)+","+temp$(3)+","+temp$(4)+","+temp$(5)+","+temp$(6)+","+temp$(7)+","+temp$(8)
            next_reading            
          NEXT count
        ENDIF
      ELSEIF x >= 15 and y >= 120 and x <= 15+90 and y <= 200+40 THEN
        sc$ = "diag"
        Orig_scales = Ascale + Vscale * 10000
      ELSEIF x >= 115 and y >= 120 and x <= 115+90 and y <= 200+40 THEN
        Calibrate
        sc$ = "main"
      ELSEIF y >= 65 and y <= 105 and logging_status = 0 THEN
        IF log_interval = 60 THEN
          log_interval = 10
        ELSEIF log_interval = 10 THEN
          log_interval = 1
        ELSE
          log_interval = 60
        ENDIF
        VAR SAVE log_interval
      ELSE
        sc$ = "main"
      ENDIF
    ELSEIF sc$ = "hols" THEN
      LOCAL num, cur_str$ LENGTH 10
      IF y >= 20 AND (x < 120 OR x > 200) THEN
        num = ((y-20) \ 20) * 2
        IF x > 160 THEN num = num + 1
        cur_str$ = get_holiday$(num)
        IF cur_str$ = "--/--/--" THEN cur_str$ = ""
        cur_str$ = GetStr$("Public holiday date:", "", "New date:", cur_str$, "/", 8, 1)
        '       ELSE
        '         cur_str$ = LEFT$(cur_str$, 6) + "20" + RIGHT$(cur_str$, 2)
        if cur_str$ <> "" THEN set_holiday(num, cur_str$)
      ELSE
        sc$ = "tariff"
      ENDIF
    ELSEIF sc$ = "diag" THEN
      IF x >= 230 and x < 280 THEN
        IF y >= 12 and y < 62 THEN
          Text 260, 42, "-", cm, 7, , RGB(Red)
          IF Vscale < 1200 THEN Vscale = Vscale + 1
RedrawAndTop:
          next_reading
          SHOW_SCREEN sc$, 1
          GOTO Top
        ELSEIF y >= 62 AND y < 112 THEN
          Text 260, 90, "-", cm, 7, , RGB(Red)
          IF Ascale < 2000 THEN Ascale = Ascale + 10
          GOTO RedrawAndTop
        ENDIF
      ELSEIF x >= 280 and x < 320 THEN
        IF y >= 12 and y < 62 THEN
          Text 300, 42, "-", cm, 7, , RGB(Red)
          IF Vscale > 700 THEN Vscale = Vscale - 1
          GOTO RedrawAndTop
        ELSEIF y >= 62 AND y < 112 THEN
          Text 300, 90, "-", cm, 7, , RGB(Red)
          IF Ascale > 1200 THEN Ascale = Ascale - 10
          GOTO RedrawAndTop
        ENDIF
      ELSE
        IF Orig_scales <> Ascale + Vscale * 10000 THEN VAR SAVE Ascale, Vscale
        sc$ = "log"
      ENDIF
    ELSE
      sc$ = "main"
    ENDIF
  ENDIF
END SUB
  
SUB get_tariffs index, st1$, fi1$, st2$, fi2$
  st1$ = MID$(tariff_times$, index*16+1, 2) + ":" + MID$(tariff_times$, index*16+3, 2)
  fi1$ = MID$(tariff_times$, index*16+5, 2) + ":" + MID$(tariff_times$, index*16+7, 2)
  st2$ = MID$(tariff_times$, index*16+9, 2) + ":" + MID$(tariff_times$, index*16+11, 2)
  fi2$ = MID$(tariff_times$, index*16+13, 2) + ":" + MID$(tariff_times$, index*16+15, 2)
END SUB
  
SUB save_tariffs index, st1$, fi1$, st2$, fi2$
  st1$ = LPAD$(st1$,5)
  st1$ = LEFT$(st1$,2)+RIGHT$(st1$,2)
  fi1$ = LPAD$(fi1$,5)
  fi1$ = LEFT$(fi1$,2)+RIGHT$(fi1$,2)
  st2$ = LPAD$(st2$,5)
  st2$ = LEFT$(st2$,2)+RIGHT$(st2$,2)
  fi2$ = LPAD$(fi2$,5)
  fi2$ = LEFT$(fi2$,2)+RIGHT$(fi2$,2)
  LOCAL paste$ LENGTH 16 = st1$+fi1$+st2$+fi2$
  tariff_times$ = LEFT$(tariff_times$,16*index)+paste$+RIGHT$(tariff_times$,16*(3-index))
  VAR SAVE tariff_times$
END SUB
  
SUB show_tariffs index, ypos, what$
  LOCAL st1$ LENGTH 5, fi1$ LENGTH 5, st2$ LENGTH 5, fi2$ LENGTH 5
  get_tariffs(index, st1$, fi1$, st2$, fi2$)
  IF st1$ = st2$ and fi1$ = fi2$ THEN
    IF st1$ <> fi1$ THEN
      Text 0, ypos, what$ + ": "+st1$+"-"+fi1$, lt, 7, , White
    ELSE
      Text 0, ypos, what$ + ": N/A", lt, 7, , White
    ENDIF
  ELSE
    Text 0, ypos-5, what$ + "1:"+st1$+"-"+fi1$, lt, 7, , White
    Text 0, ypos+10, what$ + "2:"+st2$+"-"+fi2$, lt, 7, , White
  ENDIF
END SUB
  
FUNCTION get_holiday$(index, full)
  LOCAL ret$ LENGTH 10
  ret$ = MID$(tariff_holidays$, 1+index*6, 6)
  IF ret$ = "      " THEN
    ret$ = "--/--/--"
  ELSE
    LOCAL day$ LENGTH 2 = LEFT$(ret$, 2)
    LOCAL mon$ LENGTH 2 = MID$(ret$, 3, 2)
    LOCAL year$ LENGTH 2 = RIGHT$(ret$, 2)
    ret$ = day$ + "/" + mon$ + "/" + year$
  ENDIF
  IF full > 0 THEN
    LOCAL l$ LENGTH 6 = LEFT$(ret$, 6);
    LOCAL r$ LENGTH 2 = RIGHT$(ret$, 2)
    ret$ = l$ + "20" + r$
  ENDIF
  get_holiday$ = ret$
END FUNCTION
  
SUB set_holiday index, holiday$
  tariff_holidays$ = LEFT$(tariff_holidays$, index*6) + LPAD0$(LEFT$(holiday$, 2) + MID$(holiday$, 4, 2) + RIGHT$(holiday$, 2), 6) + RIGHT$(tariff_holidays$, (21-index)*6)
  VAR SAVE tariff_holidays$
END SUB
  
SUB SHOW_SCREEN sc$, NO_CLEAR
  IF RIGHT$(sc$, 4) = "plot" OR RIGHT$(sc$, 4) = "hist" THEN COLOUR WHITE, RGB(48,48,48)
  IF NO_CLEAR = 0 THEN
    CLS
    last_graph$ = ""
  ENDIF
  LOCAL min, max, avg
  IF RIGHT$(sc$, 4) = "plot" OR RIGHT$(sc$, 4) = "hist" THEN
    LOCAL round = 1
    LOCAL what$ LENGTH 16 = LEFT$(sc$, LEN(sc$)-4)
    IF what$ = "a" or what$ = "pf" THEN round = 0.1
    IF what$ = "va" or what$ = "w" THEN round = 10
    if RIGHT$(sc$, 4) = "hist" THEN
      IF num_datum > 0 THEN
        LOCAL actual_duration = graph_duration / log_interval
        IF num_datum < actual_duration THEN actual_duration = num_datum
        LOCAL num_bins = actual_duration \ 10
        IF num_bins < 2 THEN num_bins = 2
        IF num_bins > 10 THEN num_bins = 10
        HISTOGRAM round, num_datum - actual_duration, num_datum, what$, num_bins, 14, 319-14, 52, 52+172-16, 75, NO_CLEAR, min, max, avg
        Text MM.Hres/2, 52+172, "Duration: " + duration_str$(actual_duration * log_interval), ct, 7, , rgb(192,192,255)'col_v
      ELSE
        TEXT MM.Hres/2, 52+172/2, "No data", cm, 1, , White
      ENDIF
    ELSE
      LOCAL num_vals = 120'max_plot
      LOCAL actual_duration = num_datum
      LOCAL graph_values(num_vals)
      IF actual_duration > num_vals THEN actual_duration = actual_duration \ num_vals * num_vals
      if actual_duration > graph_duration / log_interval THEN actual_duration = graph_duration / log_interval
      IF num_vals > actual_duration THEN num_vals = actual_duration
      IF num_vals > 1 THEN
        populate_array_values(graph_values(), num_datum - actual_duration, num_vals, actual_duration / num_vals, what$, min, max, avg)
        IF touchpos(1) = -1 AND last_graph$ <> (what$ + "plot") + STR$(actual_duration) + "," + STR$(num_datum - actual_duration) THEN
          '          IF NO_CLEAR > 0 THEN BOX 28, 52, 319-28, 172, 0, , RGB(black)
          BOX 28, 52, 319-28, 172, 0, , RGB(black)
          draw_graph(graph_values(), round, num_vals, 28, 319, 52, 52+172, actual_duration * log_interval)
          
          last_graph$ = (what$ + "plot") + STR$(actual_duration) + "," + STR$(num_datum - actual_duration)
        ENDIF
      ELSE
        TEXT MM.Hres/2, 52+172/2, "No data", cm, 1, , White
      ENDIF
    ENDIF
    IF what$ = "v" THEN
      COLOUR rgb(192,192,255)'col_v
      Text 0, 0, STR$(volts, 3, 0) + "VAC", lt, 8
      Text 319, 0, "Min " + STR$(min, 3, 1) + "V", rt, 7
      Text 319, 16, "Max " + STR$(max, 3, 1) + "V", rt, 7
      Text 319, 32, "Avg " + STR$(avg, 3, 1) + "V", rt, 7
    ELSEIF what$ = "a" THEN
      COLOUR rgb(255,128,128)'col_a
      Text 0, 0, STR$(amps, 2, 2) + "A", lt, 8
      Text 319, 0, "Min " + STR$(min, 2, 2) + "A", rt, 7
      Text 319, 16, "Max " + STR$(max, 2, 2) + "A", rt, 7
      Text 319, 32, "Avg " + STR$(avg, 2, 2) + "A", rt, 7
    ELSEIF what$ = "pf" THEN
      COLOUR rgb(220,220,220)'col_pf    
      Text 0, 0, "PF=" + STR$(pf, 1, 2), lt, 8
      Text 319, 0, "Min " + STR$(min, 1, 2), rt, 7
      Text 319, 16, "Max " + STR$(max, 1, 2), rt, 7
      Text 319, 32, "Avg " + STR$(avg, 1, 2), rt, 7
    ELSEIF what$ = "va" THEN
      COLOUR rgb(128,255,255)'col_va
      Text 0, 0, PRINTW$(volts * amps, 4) + "VA", lt, 8
      Text 319, 0, "Min " + PRINTW$(min, 4), rt, 7
      Text 319, 16, "Max " + PRINTW$(max, 4), rt, 7
      Text 319, 32, "Avg " + PRINTW$(avg, 4), rt, 7
    ELSEIF what$ = "w" THEN
      COLOUR rgb(255,128,255)'col_w
      Text 0, 0, PRINTW$(volts * amps * pf, 4) + "W", lt, 8
      Text 319, 0, "Min " + PRINTW$(min, 4) + "W", rt, 7
      Text 319, 16, "Max " + PRINTW$(max, 4) + "W", rt, 7
      Text 319, 32, "Avg " + PRINTW$(avg, 4) + "W", rt, 7
    ENDIF
    COLOUR WHITE, RGB(0,0,0)
  ELSEIF sc$ = "energy" THEN
    Text 0, 0, PRINTW$(accum_mWs / 3600000000, 4) + "kWh", lt, 8, , White
    Text 320, 6, duration_str$(log_duration * log_interval, "daysonly") + ",", rt, 7, , rgb(255,192,0)'col_dur
    Text 320, 26, duration_str$(log_duration * log_interval, "nodays"), rt, 7, , rgb(255,192,0)'col_dur
    LOCAL kWh$ LENGTH 8 = "?????"
    IF log_duration > 0 THEN kWh$ = PRINTW$(accum_mWs / (log_duration * log_interval * 1000000), 4)
    Text 0, 48, kWh$ + "kWh/hour", lt, 8, , rgb(cyan)
    IF log_duration > 0 THEN kWh$ = PRINTW$(accum_mWs / (log_duration * log_interval * 1000000 / 24), 4)
    Text 0, 96, kWh$ + "kWh/day", lt, 8, , rgb(green)
    IF log_duration > 0 THEN kWh$ = PRINTW$(accum_mWs / (log_duration * log_interval * 1000000 / (24 * 7)), 4)
    Text 0, 144, kWh$ + "kWh/week", lt, 8, , rgb(magenta)
    IF log_duration > 0 THEN kWh$ = PRINTW$(accum_mWs / (log_duration * log_interval * 1000000 / (24 * 365.2422)), 4)
    Text 0, 192, kWh$ + "kWh/year", lt, 8, , rgb(red)
  ELSEIF sc$ = "cost" THEN
    Text 0, 0, PRINTCOST$(accum_cost_mc / 100000000), lt, 8, , rgb(255,255,128)'col_cost
    Text 320, 6, duration_str$(log_duration * log_interval, "daysonly") + ",", rt, 7, , rgb(255,192,0)'col_dur
    Text 320, 26, duration_str$(log_duration * log_interval, "nodays"), rt, 7, , rgb(255,192,0)'col_dur
    LOCAL cost$ LENGTH 8 = "   $?.??"
    IF log_duration > 0 THEN cost$ = PRINTCOST$(accum_cost_mc * 9 / (log_duration * log_interval * 250000))
    Text 0, 48, cost$ + "/hour", lt, 8, , rgb(cyan)
    IF log_duration > 0 THEN cost$ = PRINTCOST$(accum_cost_mc * 9 * 24 / (log_duration * log_interval * 250000))
    Text 0, 96, cost$ + "/day", lt, 8, , rgb(green)
    IF log_duration > 0 THEN cost$ = PRINTCOST$(accum_cost_mc * 9 * 24 * 7 / (log_duration * log_interval * 250000))
    Text 0, 144, cost$ + "/week", lt, 8, , rgb(magenta)
    IF log_duration > 0 THEN cost$ = PRINTCOST$(accum_cost_mc * 9 * 24 * 365.2422 / (log_duration * log_interval * 250000))
    Text 0, 192, cost$ + "/year", lt, 8, , rgb(red)
  ELSEIF sc$ = "tariff" THEN
    Text 320, 0, "Peak: " + STR$(tariffs(3) / 1000, 2, 2) + "c/kWh", rt, 7, , rgb(255,255,128)'col_cost
    Text 30, 12, "back", cm, 1, , White
    Box 0, 0, 60, 22
    show_tariffs 0, 30, "Weekday"
    show_tariffs 1, 60, "Weekend"
    Text 0, 90, "Shoulder: " + STR$(tariffs(2) / 1000, 2, 2) + "c/kWh", lt, 7, , rgb(255,255,128)'col_cost
    show_tariffs 2, 120, "Weekday"
    show_tariffs 3, 150, "Weekend"
    Text 0, 180, "Off-peak: " + STR$(tariffs(1) / 1000, 2, 2) + "c/kWh", lt, 7, , rgb(255,255,128)'col_cost
    Text 0, 210, "Holidays: " + get_holiday$(0, 1) + ", " + get_holiday$(1, 1) + ", ...", lt, 1, , White
  ELSEIF sc$ = "hols" THEN
    LOCAL count
    Text 160, 0, "Public Holidays", ct, 7, , White
    Text 160, 120, "(D/M/Y)", ct, 1, , White
    FOR count = 0 to 10
      Text 0, 20*(count+1), get_holiday$(count*2), lt, 7, , rgb(220,220,220)
      Text 320, 20*(count+1), get_holiday$(count*2+1), rt, 7, , rgb(220,220,220)
    NEXT count
  ELSEIF sc$ = "log" THEN
    Text 160, 0, "Logging", ct, 7, , White
    COLOUR rgb(255, 64, 64)
    IF logging_status > 0 THEN
      if logging_status > 1 THEN
        Text 0, 25, "  Status: paused", lt, 7
      ELSE
        Text 0, 25, "  Status: active", lt, 7
      ENDIF
    ELSE
      Text 0, 25, "  Status: inactive", lt, 7
    ENDIF
    Text 0, 45, "Duration: " + duration_str$(log_duration * log_interval), lt, 7, , rgb(cyan)
    LOCAL duration$ LENGTH 16
    LOCAL maximum$ LENGTH 16
    IF log_interval = 1 THEN
      duration$ = "one second"
      maximum$ = "2.8hours"
    ELSEIF log_interval = 10 THEN
      duration$ = "10 seconds"
      maximum$ = "one day "
    ELSE'IF log_interval = 60 THEN
      duration$ = "one minute"
      maximum$ = "one week"
    ENDIF
    Text 0, 65, "Interval: " + duration$, lt, 7, , rgb(green)
    Text 0, 85, " Maximum: " + maximum$, lt, 7, , rgb(yellow)
    Text 0, 105, "RAM used: " + str$(num_datum * 4) + "b", lt, 7, , rgb(magenta)
    Text 0, 125, "RAM free: " + STR$(40320 - num_datum * 4) + "b", lt, 7, , rgb(255, 128, 255)
    COLOUR rgb(255,255,128)
    IF logging_status > 0 THEN
      Box 15, 150, 90, 40
      IF logging_status > 1 THEN
        Text 60, 170, "Resume", cm, 1, , White
      ELSE
        Text 60, 170, "Pause", cm, 7, , White
      ENDIF
    ENDIF
    Box 115, 150, 90, 40
    IF logging_status > 0 THEN
      Text 160, 170, "Stop", cm, 7, , White
    ELSE
      Text 160, 170, "Start", cm, 7, , White
    ENDIF
    IF num_datum > 0 and logging_status <> 1 THEN
      Box 215, 150, 90, 40
      Text 260, 170, "Dump", cm, 7, , White
    ENDIF
    Box 15, 200, 90, 40
    Text 60, 220, "Diag.", cm, 7, , White
    Box 115, 200, 90, 40
    Text 160, 220, "Calib", cm, 7, , White
    Box 215, 200, 90, 40
    Text 260, 220, "Back", cm, 7, , White
  ELSEIF sc$ = "diag" THEN
    COLOUR White
    Text 160, 0, "Diagnostics", ct, 7
    Text 0, 20, STR$(volts, 4, 1) + "VAC", lt, 8, , rgb(192,192,255)'col_v
    Box 240, 22, 40, 40
    Text 260, 42, "-", cm, 7
    Box 280, 22, 40, 40
    Text 300, 42, "+", cm, 7
    Text 0, 68, STR$(amps, 2, 3) + "A", lt, 8, , rgb(255,128,128)'col_a
    Box 240, 70, 40, 40
    Text 260, 90, "-", cm, 7
    Box 280, 70, 40, 40
    Text 300, 90, "+", cm, 7
    Text 0, 124, "VScl:" + STR$(Vscale, 4, 0) + " AScl: "+STR$(AScale, 4, 0), lt, 7
    Text 0, 144, "V*A:" + PRINTW$(volts*amps,4) + ", VA: " + PRINTW$(va,4), lt, 7
    Text 0, 164, "V DC level : " + STR$(ReadVA(9) * 2.048 / 32768, 2, 3) + "V", lt, 7
    Text 0, 184, "A DC level : " + STR$(AMPOFFSET * 20.48 / 32768, 2, 3) + "A", lt, 7
    Text 0, 204, "A RMS noise: " + STR$(AMPNOISE, 2, 3) + "A", lt, 7
    Text 0, 224, "Smp/Fq: " + STR$(sampling_rate, 4, 0) + "/" + STR$(frequency, 2, 2) + "Hz", lt, 7
  ELSEIF sc$ = "main" THEN
    Text 0, 0, STR$(CINT(volts), 3) + "VAC", lt, 8, , rgb(192,192,255)'col_v
    Text 319, 0, PRINTW$(volts * amps * pf, 3) + "W ", rt, 8, , rgb(255,128,255)'col_w
    Text 0, 48, STR$(amps, 2, 2) + "A", lt, 8, , rgb(255,128,128)'col_a
    Text 319, 48, PRINTW$(volts * amps, 3) + "VA", rt, 8, , rgb(128,255,255)'col_va
    COLOUR rgb(220,220,220)'col_pf
    if pf >= 0.995 THEN
      Text 0, 104, "PF=1.0", lt, 7
    ELSE
      Text 0, 104, "PF=" + RIGHT$(STR$(pf, 1, 2), 3), lt, 7
    ENDIF
    Text 0, 120, "F=" + STR$(frequency, 0, 0) + "Hz ", lt, 7
    Text 319, 96, PRINTW$(accum_mWs / 3600000000, 4) + "kWh", rt, 8, , White
    Text 319, 144, PRINTCOST$(accum_cost_mc / 100000000), rt, 8, , rgb(255,255,128)'col_cost
    Text 319, 214, MYTIME$(), rb, 7, , rgb(255,192,0)'col_dur
    Text 319, 234, MYDATE$(4), rb, 7, , rgb(255,192,0)'col_dur
    LOCAL INTEGER which_tariff = WhichTariff(DATE$, TIME$, tariff_times$, tariff_holidays$)
    LOCAL tariff_name$ LENGTH 8 = "OFF-PEAK"
    IF which_tariff = 2 THEN tariff_name$ = "SHOULDER"
    IF which_tariff = 3 THEN tariff_name$ = "PEAK -  "
    Text 0, 152, tariff_name$, lt, 7, , rgb(255,255,128)'col_cost
    Text 0, 170, STR$(tariffs(which_tariff) / 1000, 3, 2), lt, 7, , rgb(255,255,128)'col_cost
    Text 98, 170+4, "c/kWh", lt, 1, , rgb(255,255,128)'col_cost
    Text 0, 214, duration_str$(log_duration * log_interval, "daysonly") + ",", lb, 7, , rgb(255,192,0)
    Text 0, 234, duration_str$(log_duration * log_interval, "nodays"), lb, 7, , rgb(255,192,0)
  END IF
END SUB
  
FUNCTION update_readings(w)
  LOCAL INTEGER reading_count, volt_sum, amp_sum, va_sum, w_sum
  update_readings = ReadVA(8, volt_sum, amp_sum, va_sum, w_sum, reading_count)
  
  zero_crossings = zero_crossings + update_readings
  IF zero_crossings >= 200 THEN
'    LOCAL INTEGER tval = TIMER
'    PRINT STR$(zero_crossings) + ", " + STR$(tval)
    frequency = zero_crossings * 500 / TIMER
    TIMER = 0
    zero_crossings = 0
  ENDIF
  
  IF reading_count > 0 THEN
    LOCAL volts2, amps2
    volts2 = SQR(volt_sum / reading_count) * 10 / Vscale
    '    PRINT "va_sum = " + STR$(va_sum) + " zc = " + STR$(update_readings)
    IF va_sum > 0 THEN va = va_sum / (Vscale * Ascale * reading_count / 10) ELSE va = w
    IF volts2 > 0 THEN amps2 = SQR(amp_sum / reading_count) / Ascale ELSE amps2 = 0'va / volts2
    IF w_sum > 0 THEN w = w_sum / (Vscale * Ascale * reading_count / 10) ELSE w = 0
    w = w - va
    IF w < 0 THEN w = 0
'    IF w > va THEN w = w - va ELSE w = 0
    va = va + w
'    PRINT STR$(w) + ", " + STR$(va)
'    IF va > 0 THEN w = w * volts2 * amps2 / va
    IF amps2 > AMPNOISE THEN
      LOCAL old_amps2 = amps2
      amps2 = SQR(amps2 * amps2 - AMPNOISE * AMPNOISE)' - AMPNOISE / 2
      IF amps2 < 0 THEN amps2 = 0
      '      PRINT STR$(amps2) + " " + STR$(old_amps2)
      IF old_amps2 > 0 THEN w = w * amps2 / old_amps2
    ELSE
      amps2 = 0
      w = 0
    ENDIF
    '    amps2 = SQR(amp_sum / reading_count) / Ascale
    IF w > volts2 * amps2 THEN w = volts2 * amps2
    if frequency > 0 and update_readings > 0 THEN sampling_rate = reading_count * frequency*2 / update_readings
    
    avg_v = avg_v + volts2 * zero_crossings
    avg_a = avg_a + amps2 * zero_crossings
    avg_w = avg_w + w * zero_crossings
    num_avgs = num_avgs + zero_crossings
  ENDIF
END FUNCTION

SUB CheckRTC
  IF TIME$ <> CHECKTIME$ THEN
    CHECKTIME$ = TIME$
    log_wait = log_wait + 1
  END IF
END SUB

sub next_reading
  LOCAL w
  LOCAL INTEGER zerocross_count = update_readings(w)
  LOCAL CURDATE$ LENGTH 10, CURTIME$ LENGTH 8
  
  CURDATE$ = DATE$
  CURTIME$ = TIME$
  IF LASTTIME$ <> CURTIME$ AND num_avgs > 0 THEN
    volts = avg_v / num_avgs
    amps = avg_a / num_avgs
    IF volts * amps > 0 THEN pf = avg_w / (volts * amps * num_avgs) ELSE pf = 0
  ENDIF
  
  if logging_status = 1 THEN
    IF frequency > 0 THEN wait_mWs = wait_mWs + w * 500 * zerocross_count / frequency
    
    IF LASTTIME$ <> CURTIME$ THEN
      accum_mWs = accum_mWs + wait_mWs
      accum_cost_mc = accum_cost_mc + wait_mWs * tariffs(WhichTariff(CURDATE$, CURTIME$, tariff_times$, tariff_holidays$)) / 360000
      wait_mWs = 0
      
      'log_wait = log_wait + 1
      IF RIGHT$(LASTTIME$, 2) = "00" THEN store_readings
    ENDIF

    IF num_avgs > 0 THEN
'      CheckRTC
      WHILE log_wait >= log_interval
        log_wait = log_wait - log_interval
        store_datum'IF num_avgs > 0 THEN store_datum
        log_duration = log_duration + 1
      WEND
    ENDIF
  ENDIF
  
  IF LASTTIME$ <> CURTIME$ THEN
    avg_v = 0
    avg_a = 0
    avg_w = 0
    num_avgs = 0
  ENDIF
  LASTTIME$ = CURTIME$
end sub
  
SUB store_datum
  if num_datum < 10080 THEN'max_datum THEN
    LOCAL INTEGER amp_val = CINT(amps * 800)
    LOCAL INTEGER volt_val = CINT(volts * 4)
    LOCAL INTEGER pf_val = CINT(pf * 500)
    if amp_val > 8191 THEN amp_val = 8191
    if volt_val > 1023 THEN volt_val = 1023
    if pf_val > 511 THEN pf_val = 511
    LOCAL INTEGER datum = amp_val + (((pf_val << 10) + volt_val) << 13)
    if num_datum MOD 2 = 0 THEN
      data_store(num_datum \ 2 + 1) = datum
    ELSE
      data_store(num_datum \ 2 + 1) = data_store(num_datum \ 2 + 1) XOR (datum << 32)
    ENDIF
    num_datum = num_datum + 1
  ENDIF
END SUB
  
FUNCTION get_datum(num, what$)
  IF num >= 0 and num < 10080 THEN'max_datum THEN
    LOCAL INTEGER datum
    LOCAL amp_val, volt_val, pf_val
    datum = data_store(num \ 2 + 1)
    IF num MOD 2 = 0 THEN
      datum = datum AND &HFFFFFFFF
    ELSE
      datum = datum >> 32
    ENDIF
    amp_val = (datum AND &H1FFF) / 800
    volt_val = ((datum >> 13) AND &H3FF) / 4
    pf_val = (datum >> 23) / 500
    IF what$ = "a" THEN
      get_datum = amp_val
    ELSEIF what$ = "v" THEN
      get_datum = volt_val
    ELSEIF what$ = "pf" THEN
      get_datum = pf_val
    ELSEIF what$ = "va" THEN
      get_datum = amp_val * volt_val
    ELSE'IF what$ = "w" THEN
      get_datum = amp_val * volt_val * pf_val
    ENDIF
  ENDIF
END FUNCTION
  
SUB populate_array_values arr(), start_datum, num_vals, num_averages, what$, min, max, avg
  LOCAL sum, datum, count, avgnum
  min = 99999999
  max = -99999999
  avg = 0
  FOR count = 1 TO num_vals
    sum = 0
    FOR avgnum = 1 TO num_averages
      datum = get_datum(start_datum, what$)
      if datum < min THEN min = datum
      if datum > max THEN max = datum
      sum = sum + datum
      start_datum = start_datum + 1
    NEXT avgnum
    arr(count) = sum / num_averages
    avg = avg + arr(count)
    IF touchpos(1) <> -1 THEN count = num_vals
    IF count MOD 120 = 0 THEN next_reading
  NEXT count
  avg = avg / num_vals
abort_pop:
END SUB
  
FUNCTION TrimNum(MyStr$, num, min, max, dp$)
  TrimNum = 1
  IF dp$ = "" THEN
    IF LEN(MyStr$) > 0 THEN
      num = VAL(MyStr$)
      IF num >= min AND num < max THEN TrimNum = 0
    ENDIF
  ELSE
    LOCAL count
    LOCAL char$ LENGTH 1
    FOR count = 1 TO LEN(MyStr$)
      char$ = MID$(MyStr$, count, 1)
      IF char$ = dp$ AND count > 1 THEN
        num = VAL(LEFT$(MyStr$, count-1))
        IF num >= min AND num <= max THEN TrimNum = 0
        MyStr$ = RIGHT$(MyStr$, LEN(MyStr$) - count)
        count = LEN(MyStr$)
      ENDIF
    NEXT count
  ENDIF
END FUNCTION
  
FUNCTION GetStr$(prompt_text$, suffix$, new_prompt$, cur$, dp$, maxlen, allow_blank_ret)
  LOCAL KPInStr$ LENGTH 16 = "", KPStr$ LENGTH 16
  LOCAL hour_day, minute_mon, sec_year
  LOCAL INTEGER valid = 0, colour
  
  KPAD$ = LEFT$(KPAD$,11) + dp$
  
  CLS
  COLOUR White, RGB(Black)
  TEXT 0,MM.VRes/16, prompt_text$, LM,1,1
  TEXT MM.HRes/4, MM.VRes*3/16, cur$ + suffix$, CM, 1, 1.8
  TEXT 0, MM.VRes*5/16, new_prompt$, LM, 1,1
  BOX 0, MM.VRes*3/8, MM.HRes/2-4, MM.VRes/8, 0, White, White
  KPadDraw
  
  DO
    KPStr$ = InCharFrmKP$()
    IF KPStr$ = "OK" THEN
      IF LEN(KPInStr$) = 0 and allow_blank_ret > 0 THEN
        IF allow_blank_ret = 1 THEN KPInStr$ = cur$
        EXIT DO
      ELSEIF valid > 0 THEN
        IF dp$ = ":" and maxlen > 5 and LEN(KPInStr$) = 5 THEN KPInStr$ = KPInStr$ + ":00"
        EXIT DO
      ENDIF
    ELSEIF KPStr$ = CHR$(08) THEN
      IF LEN(KPInStr$) > 0 THEN
        KPInStr$ = Left$(KPInStr$, LEN(KPInStr$)-1)
        GOTO UpdateDisplay
      ENDIF
    ELSEIF KPStr$ = "x" THEN
      KPInStr$ = ""
      EXIT DO
    ELSEIF len(KPInStr$) < maxlen THEN
      KPInStr$ = KPInStr$ + KPStr$
UpdateDisplay:
      valid = 0
      IF dp$ = ":" THEN
        KPStr$ = KPInStr$
        IF TrimNum(KPStr$, hour_day, 0, 23, ":") = 0 THEN
          IF (maxlen = 5 OR LEN(KPInStr$) < 8 OR TrimNum(KPStr$, minute_mon, 0, 59, ":") = 0) THEN
            IF LEN(KPStr$) = 2 and TrimNum(KPStr$, sec_year, 0, 59, "") = 0 THEN
              IF maxlen > 5 AND LEN(KPInStr$) > 5 THEN
                KPInStr$ = STR$(hour_day)
                KPStr$ = STR$(minute_mon)
                KPInStr$ = LPAD0$(KPInStr$, 2) + ":" + LPAD0$(KPStr$, 2)
              ELSE
                KPInStr$ = STR$(hour_day)
              ENDIF
              KPStr$ = STR$(sec_year)
              KPInStr$ = LPAD0$(KPInStr$, 2) + ":" + LPAD0$(KPStr$, 2)
              valid = 1
            ENDIF
          ENDIF
        ENDIF
      ELSEIF dp$ = "/" THEN
        KPStr$ = KPInStr$
        IF TrimNum(KPStr$, hour_day, 1, 31, "/") = 0 AND TrimNum(KPStr$, minute_mon, 1, 12, "/") = 0 AND LEN(KPStr$) = 2 and TrimNum(KPStr$, sec_year, 0, 99, "") = 0 THEN
          KPInStr$ = STR$(hour_day)
          KPStr$ = STR$(minute_mon)
          KPInStr$ = LPAD0$(KPInStr$, 2) + "/" + LPAD0$(KPStr$, 2)
          KPStr$ = STR$(sec_year)
          KPInStr$ = KPInStr$ + "/" + LPAD0$(KPStr$, 2)
          valid = 1
        ENDIF
      ELSE
        IF VAL(KPInStr$) <> 0 THEN valid = 1
      ENDIF
      BOX 0, MM.VRes*3/8, MM.HRes/2-4, MM.VRes/8, 0, White, White
      colour = RGB(Red)
      IF valid > 0 THEN colour = RGB(Black)
      TEXT MM.HRes/4-2, MM.VRes*7/16, KPInStr$, CM, 1,2, colour, White
'      PAUSE 200
    ENDIF
    PAUSE 50
    next_reading
  LOOP
  GetStr$ = KPInStr$
END FUNCTION
  
SUB KPadDraw
  LOCAL x, y
  FOR y = 0 to 3
    FOR x = 3 TO 5
      RBOX MM.HRes*x/6, MM.VRes*y/4, MM.HRes/6-4, MM.VRes/4-4, 10, RGB(Black), RGB(255,255,192)
      TEXT MM.HRes*(x*2+1)/12, MM.VRes*(y*2+1)/8, MID$(KPad$, y*3+x-2, 1), CM, 1, 3, RGB(Black), RGB(255,255,192)
    NEXT x
  NEXT y
  
  RBOX 0, MM.VRes*3/4, MM.HRes/6-4, MM.VRes/4, 10, RGB(Black), RGB(255,255,192)
  RBOX MM.HRes/6, MM.VRes*3/4, MM.HRes/3-4, MM.VRes/4, 10, RGB(Black), RGB(255,255,192)
  TEXT MM.HRes/12, MM.VRes*7/8, "<-", CM, 1, 2, RGB(Black), RGB(255,255,192)
  TEXT MM.HRes/3, MM.VRes*7/8, "OK", CM, 1, 3, RGB(Red), RGB(255,255,192)
END SUB
  
FUNCTION InCharFrmKP$()   ' sub to get a char from the touch keypad
  LOCAL x, y
ICFK2: x = touchpos(1)
  y = touchpos(2)
  touchpos(1) = -1
  next_reading
  IF x = -1 OR y = -1 OR (x < MM.HRes/2 AND y < MM.VRes*3/4) THEN GOTO ICFK2
  
  IF x < MM.HRes/6 THEN
    InCharFrmKP$ = CHR$(08) 'backspace
  ELSEIF x < MM.HRes/2-1 THEN
    InCharFrmKP$ = "OK"
  ELSE
    InCharFrmKP$ = MID$(KPad$, (y \ (MM.VRes/4))*3+(x \ (MM.HRes\6))-2, 1)
  ENDIF
END FUNCTION
  
  SETPIN 21, DOUT         ' make pin 21 a digital output (used for ADC CS/CONV)
  SETPIN 22, DOUT         ' make pin 22 a digital output (used for ADC CS/CONV)
  PIN(21) = 1             ' and set it high to make sure the ADC SPI is disabled
  
  SETPIN 9, DOUT  ' ADC SDI
  SETPIN 10, DIN  ' ADC SDO
  SETPIN 24, DOUT ' ADC SCK
  
  SETPIN 15, INTL, TouchInt
  
  CPU 48
  RTC GETTIME   ' first get the date and time from the RTC module
  LASTTIME$ = TIME$
  SETTICK 3600000, UPDATETime, 4
  CHECKTIME$ = TIME$
  SETTICK 100, CheckRTC, 3
SUB UPDATETime
  RTC GETTIME ' reset the time
END SUB
  
  VAR RESTORE
  num_datum = ReadVA(1, 0)
  IF AMPOFFSET <> 0 THEN num_datum = ReadVA(10, AMPOFFSET)
  IF AVGDCLEVEL <> 0 THEN num_datum = ReadVA(11, AVGDCLEVEL)
  num_datum = 0
  restore_readings

  WHILE 1
    SHOW_SCREEN cur_screen$
    WAITFORPRESS cur_screen$
  WEND

CFunction ReadVA
    000000FF
    'AccumulateLongLong
    8C820000 8C870004 8CA30000 8CA60004 00431821 00E63021 0062102B 00461021 
    AC830000 AC820004 00001021 00001821 ACA20000 03E00008 ACA30004 
    'T1Int
    27BDFFE0 AFBF001C AFB10018 AFB00014 3C029D00 8C42008C 8C510004 16200003 
    8C4D0000 10000002 3403A9FF 340389FF 3063FFFF 3C02BF88 24042000 AC446134 
    24040C00 AC446134 24020010 00002021 3C0BBF88 240A0004 3C0CBF88 3C09BF88 
    3C08BF88 24052000 3C07BF88 7C033620 04C10004 00000000 AD8A6038 10000003 
    00042040 AD6A6034 00042040 8D266020 7CC600C0 00862025 AD056138 ACE56134 
    2442FFFF 10400003 00031840 1000FFEF 3063FFFF 24030C00 3C02BF88 AC436138 
    16200016 7C042620 3C029D00 8C42008C 8C45007C 10A0000C 8C430008 00033203 
    00661823 00641821 24A5FFFF 14A00002 AC45007C 00031980 3C029D00 8C42008C 
    1000008C AC430008 00032B83 00651823 00641821 10000087 AC430008 3C039D00 
    8C62008C 8448002C 8C450048 00AD6823 01A42021 7C042620 70843802 00074FC3 
    8C450018 8C4A001C 00A73821 01494821 00E5282B 00A92821 AC470018 AC45001C 
    8C62008C 8C450020 24A50001 AC450020 8C62008C 8C450024 00A42821 AC450024 
    8C62008C 8C430028 24630001 70882002 1C80003F AC430028 10000049 3C029D00 
    5460005B 3C029D00 8C430014 28650025 54A00057 3C029D00 04830005 8C45007C 
    286303E9 1460000A 3C109D00 8C45007C 10A00003 8C430008 10000002 24050008 
    2405000E 00A31807 AC430000 3C109D00 8E02008C AC44004C 8E02008C 8C430054 
    24630001 AC430054 8E05008C 24A40058 24A5000C 0411FF6B 00000000 8E05008C 
    24A40060 24A50018 0411FF66 00000000 8E05008C 24A40068 24A50030 0411FF61 
    00000000 8E05008C 24A40070 24A5003C 0411FF5C 00000000 8E02008C 8C440078 
    8C430014 00831821 AC430078 8E02008C AC400014 8E02008C AC400020 8E02008C 
    AC400038 8E02008C 10000020 AC400044 3C029D00 8C43008C 000437C3 8C620030 
    8C670034 00442021 00E63021 0082102B 00461021 AC640030 1000000B AC620034 
    8C43008C 000437C3 8C62003C 8C670040 00442023 00E63023 0044102B 00C21023 
    AC64003C AC620040 3C029D00 8C43008C 8C640038 24840001 AC640038 8C42008C 
    8C430044 24630001 AC430044 3C029D00 8C42008C 24030001 00718823 AC510004 
    8FBF001C 8FB10018 8FB00014 03E00008 27BD0020 008D2023 7C042620 3C029D00 
    8C45008C 70843802 000747C3 8CA3000C 8CA90010 00673821 01284021 00E3182B 
    00681821 ACA7000C ACA30010 8C43008C 8C650014 24A50001 AC650014 8C43008C 
    AC64002C 8C42008C 8C43004C 00831826 0460FF86 8C430014 1000FF81 286303E9 
    'getFPC
    27BDFFF8 AFBF0004 00852023 03E42021 ACC40000 8FBF0004 03E00008 27BD0008 
    'main
    27BDFFE0 AFBF001C AFB00018 00A08021 8C820000 24030001 14430058 8FA50034 
    00002021 3C059D00 24A50434 27A60010 0411FFEB 00000000 24030010 3C02BF88 
    AC431064 3C02BF88 AC401068 3C029D00 12000003 8C42008C 10000002 8E030000 
    00001821 AC430048 3C029D00 8C43008C 24040001 AC640004 8C43008C AC600008 
    8C43008C AC600000 8C43008C 00002021 00002821 AC64000C AC650010 8C43008C 
    AC600014 8C43008C AC640018 AC65001C 8C43008C AC600020 8C43008C AC600024 
    8C43008C AC600028 8C43008C AC640030 AC650034 8C43008C AC600038 8C43008C 
    AC64003C AC650040 8C43008C AC600044 8C43008C AC60004C 8C43008C AC600054 
    8C43008C 24040400 AC64007C 8FA40010 8C4200AC 3C039D00 2463003C 00641821 
    AC430000 34038030 3C02BF80 AC430600 2403000E 3C02BF80 AC430620 2403001C 
    3C02BF88 AC4310A4 24030004 3C02BF88 AC4310A8 24020010 3C03BF88 AC621034 
    3C03BF88 AC621064 3C03BF88 AC621068 00002021 1000007A 00002821 24030006 
    14430016 24030008 3C05BF88 24020010 ACA21064 3C04BF88 AC801068 3C039D00 
    8C66008C 8CC60024 AE060000 000637C3 AE060004 8C67008C 8CE60028 ACE00024 
    8C63008C AC600028 ACA21064 AC821068 00C02021 10000062 00062FC3 14430039 
    24030009 3C0BBF88 24080010 AD681064 3C0ABF88 AD401068 3C049D00 8C82008C 
    8C490054 8C43005C 8C420058 AE020000 AE030004 8C82008C 00006021 00006821 
    AC4C0058 AC4D005C 8C82008C 8C430064 8C420060 ACC20000 ACC30004 8C82008C 
    AC4C0060 AC4D0064 8C82008C 8C43006C 8C420068 ACE20000 ACE30004 8C82008C 
    AC4C0068 AC4D006C 8C82008C 8C430074 8C420070 8FA60030 ACC20000 ACC30004 
    8C82008C AC4C0070 AC4D0074 8C82008C 8C420078 ACA20000 000217C3 ACA20004 
    8C82008C AC400078 8C82008C AC400054 AD681064 AD481068 01202021 10000028 
    00092FC3 14430006 2403000A 3C029D00 8C42008C 8C440000 10000021 00042FC3 
    1443000B 2403000B 3C029D00 12000003 8C42008C 10000002 8E030000 00001821 
    AC430048 00002021 10000015 00002821 54430012 00002021 3C04BF88 24020010 
    AC821064 3C03BF88 AC601068 3C059D00 8CA6008C ACC0007C 8CA5008C 8E060000 
    00063380 ACA60008 AC821064 AC621068 8E040000 10000002 8E050004 00002821 
    00801021 00A01821 8FBF001C 8FB00018 03E00008 27BD0020 
End CFunction

